/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator.framework.recipes;

import com.dremio.jdbc.shaded.org.apache.curator.framework.CuratorFramework;
import com.dremio.jdbc.shaded.org.apache.curator.utils.ThreadUtils;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class AfterConnectionEstablished {
    private static final Logger log = LoggerFactory.getLogger(AfterConnectionEstablished.class);

    public static Future<?> execute(final CuratorFramework client, final Runnable runAfterConnection) throws Exception {
        final ExecutorService executor = ThreadUtils.newSingleThreadExecutor(ThreadUtils.getProcessName(runAfterConnection.getClass()));
        Runnable internalCall = new Runnable(){

            @Override
            public void run() {
                try {
                    client.blockUntilConnected();
                    runAfterConnection.run();
                }
                catch (Exception e) {
                    ThreadUtils.checkInterrupted(e);
                    log.error("An error occurred blocking until a connection is available", e);
                }
                finally {
                    executor.shutdown();
                }
            }
        };
        return executor.submit(internalCall);
    }

    private AfterConnectionEstablished() {
    }
}

