/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator.framework.recipes.barriers;

import com.dremio.jdbc.shaded.org.apache.curator.framework.CuratorFramework;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.BackgroundPathable;
import com.dremio.jdbc.shaded.org.apache.curator.utils.PathUtils;
import com.dremio.jdbc.shaded.org.apache.zookeeper.KeeperException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.WatchedEvent;
import com.dremio.jdbc.shaded.org.apache.zookeeper.Watcher;
import java.util.concurrent.TimeUnit;

public class DistributedBarrier {
    private final CuratorFramework client;
    private final String barrierPath;
    private final Watcher watcher = new Watcher(){

        @Override
        public void process(WatchedEvent event) {
            DistributedBarrier.this.client.postSafeNotify(DistributedBarrier.this);
        }
    };

    public DistributedBarrier(CuratorFramework client, String barrierPath) {
        this.client = client;
        this.barrierPath = PathUtils.validatePath(barrierPath);
    }

    public synchronized void setBarrier() throws Exception {
        try {
            this.client.create().creatingParentContainersIfNeeded().forPath(this.barrierPath);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    public synchronized void removeBarrier() throws Exception {
        try {
            this.client.delete().forPath(this.barrierPath);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    public synchronized void waitOnBarrier() throws Exception {
        this.waitOnBarrier(-1L, null);
    }

    public synchronized boolean waitOnBarrier(long maxWait, TimeUnit unit) throws Exception {
        boolean result;
        long startMs = System.currentTimeMillis();
        boolean hasMaxWait = unit != null;
        long maxWaitMs = hasMaxWait ? TimeUnit.MILLISECONDS.convert(maxWait, unit) : Long.MAX_VALUE;
        while (true) {
            boolean bl = result = ((BackgroundPathable)this.client.checkExists().usingWatcher(this.watcher)).forPath(this.barrierPath) == null;
            if (result) break;
            if (hasMaxWait) {
                long elapsed = System.currentTimeMillis() - startMs;
                long thisWaitMs = maxWaitMs - elapsed;
                if (thisWaitMs <= 0L) break;
                this.wait(thisWaitMs);
                continue;
            }
            this.wait();
        }
        return result;
    }
}

