/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator.framework.recipes.cache;

import com.dremio.jdbc.shaded.org.apache.curator.framework.CuratorFramework;
import com.dremio.jdbc.shaded.org.apache.curator.framework.recipes.cache.ChildData;
import com.dremio.jdbc.shaded.org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import com.dremio.jdbc.shaded.org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import com.dremio.jdbc.shaded.org.apache.curator.framework.recipes.cache.TreeCacheListener;

class TreeCacheListenerWrapper
implements CuratorCacheListener {
    private final CuratorFramework client;
    private final TreeCacheListener listener;

    TreeCacheListenerWrapper(CuratorFramework client, TreeCacheListener listener) {
        this.client = client;
        this.listener = listener;
    }

    @Override
    public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData data) {
        switch (type) {
            case NODE_CREATED: {
                this.sendEvent(data, null, TreeCacheEvent.Type.NODE_ADDED);
                break;
            }
            case NODE_CHANGED: {
                this.sendEvent(data, oldData, TreeCacheEvent.Type.NODE_UPDATED);
                break;
            }
            case NODE_DELETED: {
                this.sendEvent(oldData, null, TreeCacheEvent.Type.NODE_REMOVED);
            }
        }
    }

    @Override
    public void initialized() {
        this.sendEvent(null, null, TreeCacheEvent.Type.INITIALIZED);
    }

    private void sendEvent(ChildData node, ChildData oldNode, TreeCacheEvent.Type type) {
        TreeCacheEvent event = new TreeCacheEvent(type, node, oldNode);
        try {
            this.listener.childEvent(this.client, event);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

