/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator.framework.schema;

import com.dremio.jdbc.shaded.org.apache.curator.framework.schema.SchemaBuilder;
import com.dremio.jdbc.shaded.org.apache.curator.framework.schema.SchemaValidator;
import com.dremio.jdbc.shaded.org.apache.curator.framework.schema.SchemaViolation;
import com.dremio.jdbc.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableMap;
import com.dremio.jdbc.shaded.org.apache.curator.utils.ZKPaths;
import com.dremio.jdbc.shaded.org.apache.zookeeper.CreateMode;
import com.dremio.jdbc.shaded.org.apache.zookeeper.data.ACL;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Schema {
    private final String name;
    private final Pattern pathRegex;
    private final String fixedPath;
    private final String documentation;
    private final SchemaValidator schemaValidator;
    private final Allowance ephemeral;
    private final Allowance sequential;
    private final Allowance watched;
    private final boolean canBeDeleted;
    private final Map<String, String> metadata;

    public static SchemaBuilder builder(String path) {
        return new SchemaBuilder(null, path);
    }

    public static SchemaBuilder builder(Pattern pathRegex) {
        return new SchemaBuilder(pathRegex, null);
    }

    public static SchemaBuilder builderForRecipeParent(String parentPath) {
        return new SchemaBuilder(null, parentPath).sequential(Allowance.CANNOT).ephemeral(Allowance.CANNOT);
    }

    public static SchemaBuilder builderForRecipe(String parentPath) {
        return new SchemaBuilder(Pattern.compile(ZKPaths.makePath(parentPath, ".*")), null).sequential(Allowance.MUST).ephemeral(Allowance.MUST).watched(Allowance.MUST).canBeDeleted(true);
    }

    Schema(String name, Pattern pathRegex, String path, String documentation, SchemaValidator schemaValidator, Allowance ephemeral, Allowance sequential, Allowance watched, boolean canBeDeleted, Map<String, String> metadata) {
        Preconditions.checkArgument(pathRegex != null || path != null, "pathRegex and path cannot both be null");
        this.pathRegex = pathRegex;
        this.fixedPath = this.fixPath(path);
        this.metadata = ImmutableMap.copyOf(Preconditions.checkNotNull(metadata, "metadata cannot be null"));
        this.name = Preconditions.checkNotNull(name, "name cannot be null");
        this.documentation = Preconditions.checkNotNull(documentation, "documentation cannot be null");
        this.schemaValidator = Preconditions.checkNotNull(schemaValidator, "dataValidator cannot be null");
        this.ephemeral = Preconditions.checkNotNull(ephemeral, "ephemeral cannot be null");
        this.sequential = Preconditions.checkNotNull(sequential, "sequential cannot be null");
        this.watched = Preconditions.checkNotNull(watched, "watched cannot be null");
        this.canBeDeleted = canBeDeleted;
    }

    private String fixPath(String path) {
        if (path != null) {
            if (path.endsWith("/")) {
                return path.length() > 1 ? path.substring(0, path.length() - 1) : "";
            }
            return path;
        }
        return null;
    }

    public void validateDelete(String path) {
        if (!this.canBeDeleted) {
            throw new SchemaViolation(this, new SchemaViolation.ViolatorData(path, null, null), "Cannot be deleted");
        }
    }

    public void validateWatch(String path, boolean isWatching) {
        if (isWatching && this.watched == Allowance.CANNOT) {
            throw new SchemaViolation(this, new SchemaViolation.ViolatorData(path, null, null), "Cannot be watched");
        }
        if (!isWatching && this.watched == Allowance.MUST) {
            throw new SchemaViolation(this, new SchemaViolation.ViolatorData(path, null, null), "Must be watched");
        }
    }

    public void validateCreate(CreateMode mode, String path, byte[] data, List<ACL> acl) {
        if (mode.isEphemeral() && this.ephemeral == Allowance.CANNOT) {
            throw new SchemaViolation(this, new SchemaViolation.ViolatorData(path, data, acl), "Cannot be ephemeral");
        }
        if (!mode.isEphemeral() && this.ephemeral == Allowance.MUST) {
            throw new SchemaViolation(this, new SchemaViolation.ViolatorData(path, data, acl), "Must be ephemeral");
        }
        if (mode.isSequential() && this.sequential == Allowance.CANNOT) {
            throw new SchemaViolation(this, new SchemaViolation.ViolatorData(path, data, acl), "Cannot be sequential");
        }
        if (!mode.isSequential() && this.sequential == Allowance.MUST) {
            throw new SchemaViolation(this, new SchemaViolation.ViolatorData(path, data, acl), "Must be sequential");
        }
        this.validateGeneral(path, data, acl);
    }

    public void validateGeneral(String path, byte[] data, List<ACL> acl) {
        if (!this.schemaValidator.isValid(this, path, data, acl)) {
            throw new SchemaViolation(this, new SchemaViolation.ViolatorData(path, data, acl), "Data is not valid");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getRawPath() {
        return this.fixedPath != null ? this.fixedPath : this.pathRegex.pattern();
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Pattern getPathRegex() {
        return this.pathRegex;
    }

    public String getPath() {
        return this.fixedPath;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public SchemaValidator getSchemaValidator() {
        return this.schemaValidator;
    }

    public Allowance getEphemeral() {
        return this.ephemeral;
    }

    public Allowance getSequential() {
        return this.sequential;
    }

    public Allowance getWatched() {
        return this.watched;
    }

    public boolean canBeDeleted() {
        return this.canBeDeleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema = (Schema)o;
        if (!this.pathRegex.equals(schema.pathRegex)) {
            return false;
        }
        return this.fixedPath.equals(schema.fixedPath);
    }

    public int hashCode() {
        int result = this.pathRegex.hashCode();
        result = 31 * result + this.fixedPath.hashCode();
        return result;
    }

    public String toString() {
        return "Schema{name='" + this.name + '\'' + ", pathRegex=" + this.pathRegex + ", path='" + this.fixedPath + '\'' + ", documentation='" + this.documentation + '\'' + ", dataValidator=" + this.schemaValidator.getClass() + ", ephemeral=" + (Object)((Object)this.ephemeral) + ", sequential=" + (Object)((Object)this.sequential) + ", watched=" + (Object)((Object)this.watched) + ", canBeDeleted=" + this.canBeDeleted + ", metadata=" + this.metadata + '}';
    }

    public String toDocumentation() {
        String pathLabel = this.pathRegex != null ? "Path Regex: " : "Path: ";
        return "Name: " + this.name + '\n' + pathLabel + this.getRawPath() + '\n' + "Doc: " + this.documentation + '\n' + "Validator: " + this.schemaValidator.getClass().getSimpleName() + '\n' + "Meta: " + this.metadata + '\n' + String.format("ephemeral: %s | sequential: %s | watched: %s | canBeDeleted: %s", new Object[]{this.ephemeral, this.sequential, this.watched, this.canBeDeleted}) + '\n';
    }

    public static enum Allowance {
        CAN,
        MUST,
        CANNOT;

    }
}

