/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator.retry;

import com.dremio.jdbc.shaded.org.apache.curator.RetryPolicy;
import com.dremio.jdbc.shaded.org.apache.curator.RetrySleeper;
import com.dremio.jdbc.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;

public class RetryForever
implements RetryPolicy {
    private static final Logger log = LoggerFactory.getLogger(RetryForever.class);
    private final int retryIntervalMs;

    public RetryForever(int retryIntervalMs) {
        Preconditions.checkArgument(retryIntervalMs > 0);
        this.retryIntervalMs = retryIntervalMs;
    }

    @Override
    public boolean allowRetry(int retryCount, long elapsedTimeMs, RetrySleeper sleeper) {
        try {
            sleeper.sleepFor(this.retryIntervalMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Error occurred while sleeping", e);
            return false;
        }
        return true;
    }
}

