/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator.utils;

import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;

public class Compatibility {
    private static final Logger log;
    private static final Method getReachableOrOneMethod;
    private static final Field addrField;
    private static final boolean hasPersistentWatchers;

    public static boolean hasGetReachableOrOneMethod() {
        return getReachableOrOneMethod != null;
    }

    public static boolean hasAddrField() {
        return addrField != null;
    }

    public static String getHostString(QuorumPeer.QuorumServer server) {
        InetSocketAddress address = null;
        if (getReachableOrOneMethod != null) {
            try {
                address = (InetSocketAddress)getReachableOrOneMethod.invoke((Object)server.addr, new Object[0]);
            }
            catch (Exception e) {
                log.error("Could not call getReachableOrOneMethod.invoke({})", (Object)server.addr, (Object)e);
            }
        } else if (addrField != null) {
            try {
                address = (InetSocketAddress)addrField.get(server);
            }
            catch (Exception e) {
                log.error("Could not call addrField.get({})", (Object)server, (Object)e);
            }
        }
        return address != null ? address.getHostString() : "unknown";
    }

    public static boolean hasPersistentWatchers() {
        return hasPersistentWatchers;
    }

    static {
        boolean localHasPersistentWatchers;
        Field localAddrField;
        Method localGetReachableOrOneMethod;
        log = LoggerFactory.getLogger(Compatibility.class);
        try {
            Class<?> multipleAddressesClass = Class.forName("com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.MultipleAddresses");
            localGetReachableOrOneMethod = multipleAddressesClass.getMethod("getReachableOrOne", new Class[0]);
            log.info("Using org.apache.zookeeper.server.quorum.MultipleAddresses");
        }
        catch (ReflectiveOperationException ignore) {
            localGetReachableOrOneMethod = null;
        }
        getReachableOrOneMethod = localGetReachableOrOneMethod;
        try {
            localAddrField = QuorumPeer.QuorumServer.class.getField("addr");
        }
        catch (NoSuchFieldException e) {
            localAddrField = null;
            log.error("Could not get addr field! Reconfiguration fail!");
        }
        addrField = localAddrField;
        try {
            Class.forName("com.dremio.jdbc.shaded.org.apache.zookeeper.AddWatchMode");
            localHasPersistentWatchers = true;
        }
        catch (ClassNotFoundException e) {
            localHasPersistentWatchers = false;
            log.info("Persistent Watchers are not available in the version of the ZooKeeper library being used");
        }
        hasPersistentWatchers = localHasPersistentWatchers;
    }
}

