/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator.x.discovery;

import com.dremio.jdbc.shaded.org.apache.curator.framework.CuratorFramework;
import com.dremio.jdbc.shaded.org.apache.curator.x.discovery.DiscoveryPathConstructor;
import com.dremio.jdbc.shaded.org.apache.curator.x.discovery.ServiceDiscovery;
import com.dremio.jdbc.shaded.org.apache.curator.x.discovery.ServiceInstance;
import com.dremio.jdbc.shaded.org.apache.curator.x.discovery.details.DiscoveryPathConstructorImpl;
import com.dremio.jdbc.shaded.org.apache.curator.x.discovery.details.InstanceSerializer;
import com.dremio.jdbc.shaded.org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import com.dremio.jdbc.shaded.org.apache.curator.x.discovery.details.ServiceDiscoveryImpl;

public class ServiceDiscoveryBuilder<T> {
    private CuratorFramework client;
    private DiscoveryPathConstructor pathConstructor;
    private InstanceSerializer<T> serializer;
    private ServiceInstance<T> thisInstance;
    private Class<T> payloadClass;
    private boolean watchInstances = false;

    public static <T> ServiceDiscoveryBuilder<T> builder(Class<T> payloadClass) {
        return new ServiceDiscoveryBuilder<T>(payloadClass);
    }

    public ServiceDiscovery<T> build() {
        if (this.serializer == null) {
            this.serializer(new JsonInstanceSerializer<T>(this.payloadClass));
        }
        return new ServiceDiscoveryImpl<T>(this.client, this.pathConstructor, this.serializer, this.thisInstance, this.watchInstances);
    }

    public ServiceDiscoveryBuilder<T> client(CuratorFramework client) {
        this.client = client;
        return this;
    }

    public ServiceDiscoveryBuilder<T> basePath(String basePath) {
        this.pathConstructor = new DiscoveryPathConstructorImpl(basePath);
        return this;
    }

    public ServiceDiscoveryBuilder<T> pathConstructor(DiscoveryPathConstructor pathConstructor) {
        this.pathConstructor = pathConstructor;
        return this;
    }

    public ServiceDiscoveryBuilder<T> serializer(InstanceSerializer<T> serializer) {
        this.serializer = serializer;
        return this;
    }

    public ServiceDiscoveryBuilder<T> thisInstance(ServiceInstance<T> thisInstance) {
        this.thisInstance = thisInstance;
        return this;
    }

    public ServiceDiscoveryBuilder<T> watchInstances(boolean watchInstances) {
        this.watchInstances = watchInstances;
        return this;
    }

    ServiceDiscoveryBuilder(Class<T> payloadClass) {
        this.payloadClass = payloadClass;
    }
}

