/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator.x.discovery;

import com.dremio.jdbc.shaded.org.apache.curator.shaded.com.google.common.collect.Lists;
import com.dremio.jdbc.shaded.org.apache.curator.x.discovery.LocalIpFilter;
import com.dremio.jdbc.shaded.org.apache.curator.x.discovery.ServiceInstance;
import com.dremio.jdbc.shaded.org.apache.curator.x.discovery.ServiceType;
import com.dremio.jdbc.shaded.org.apache.curator.x.discovery.UriSpec;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicReference;

public class ServiceInstanceBuilder<T> {
    private T payload;
    private String name;
    private String address;
    private Integer port;
    private Integer sslPort;
    private String id;
    private long registrationTimeUTC;
    private ServiceType serviceType = ServiceType.DYNAMIC;
    private UriSpec uriSpec;
    private boolean enabled = true;
    private static final AtomicReference<LocalIpFilter> localIpFilter = new AtomicReference<1>(new LocalIpFilter(){

        @Override
        public boolean use(NetworkInterface nif, InetAddress adr) throws SocketException {
            return adr != null && !adr.isLoopbackAddress() && (nif.isPointToPoint() || !adr.isLinkLocalAddress());
        }
    });

    public static void setLocalIpFilter(LocalIpFilter newLocalIpFilter) {
        localIpFilter.set(newLocalIpFilter);
    }

    public static LocalIpFilter getLocalIpFilter() {
        return localIpFilter.get();
    }

    ServiceInstanceBuilder() {
    }

    public ServiceInstance<T> build() {
        return new ServiceInstance<T>(this.name, this.id, this.address, this.port, this.sslPort, this.payload, this.registrationTimeUTC, this.serviceType, this.uriSpec, this.enabled);
    }

    public ServiceInstanceBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public ServiceInstanceBuilder<T> address(String address) {
        this.address = address;
        return this;
    }

    public ServiceInstanceBuilder<T> id(String id) {
        this.id = id;
        return this;
    }

    public ServiceInstanceBuilder<T> port(int port) {
        this.port = port;
        return this;
    }

    public ServiceInstanceBuilder<T> sslPort(int port) {
        this.sslPort = port;
        return this;
    }

    public ServiceInstanceBuilder<T> payload(T payload) {
        this.payload = payload;
        return this;
    }

    public ServiceInstanceBuilder<T> serviceType(ServiceType serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    public ServiceInstanceBuilder<T> registrationTimeUTC(long registrationTimeUTC) {
        this.registrationTimeUTC = registrationTimeUTC;
        return this;
    }

    public ServiceInstanceBuilder<T> uriSpec(UriSpec uriSpec) {
        this.uriSpec = uriSpec;
        return this;
    }

    public ServiceInstanceBuilder<T> enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public static Collection<InetAddress> getAllLocalIPs() throws SocketException {
        ArrayList<InetAddress> listAdr = Lists.newArrayList();
        Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
        if (nifs == null) {
            return listAdr;
        }
        while (nifs.hasMoreElements()) {
            NetworkInterface nif = nifs.nextElement();
            Enumeration<InetAddress> adrs = nif.getInetAddresses();
            while (adrs.hasMoreElements()) {
                InetAddress adr = adrs.nextElement();
                if (!localIpFilter.get().use(nif, adr)) continue;
                listAdr.add(adr);
            }
        }
        return listAdr;
    }
}

