/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator.x.discovery.details;

import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.JavaType;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.dremio.jdbc.shaded.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.org.apache.curator.x.discovery.ServiceInstance;
import com.dremio.jdbc.shaded.org.apache.curator.x.discovery.details.InstanceSerializer;
import com.dremio.jdbc.shaded.org.apache.curator.x.discovery.details.OldServiceInstance;
import java.lang.reflect.Type;

public class JsonInstanceSerializer<T>
implements InstanceSerializer<T> {
    private final ObjectMapper mapper;
    private final Class<T> payloadClass;
    private final boolean compatibleSerializationMode;
    private final JavaType type;

    public JsonInstanceSerializer(Class<T> payloadClass) {
        this(payloadClass, true, false);
    }

    public JsonInstanceSerializer(Class<T> payloadClass, boolean compatibleSerializationMode) {
        this(payloadClass, compatibleSerializationMode, false);
    }

    @VisibleForTesting
    JsonInstanceSerializer(Class<T> payloadClass, boolean compatibleSerializationMode, boolean failOnUnknownProperties) {
        this.payloadClass = payloadClass;
        this.compatibleSerializationMode = compatibleSerializationMode;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
        this.type = this.mapper.getTypeFactory().constructType((Type)((Object)ServiceInstance.class));
    }

    @Override
    public ServiceInstance<T> deserialize(byte[] bytes) throws Exception {
        ServiceInstance rawServiceInstance = (ServiceInstance)this.mapper.readValue(bytes, this.type);
        this.payloadClass.cast(rawServiceInstance.getPayload());
        return rawServiceInstance;
    }

    @Override
    public byte[] serialize(ServiceInstance<T> instance) throws Exception {
        if (this.compatibleSerializationMode) {
            OldServiceInstance<T> compatible = new OldServiceInstance<T>(instance.getName(), instance.getId(), instance.getAddress(), instance.getPort(), instance.getSslPort(), instance.getPayload(), instance.getRegistrationTimeUTC(), instance.getServiceType(), instance.getUriSpec());
            return this.mapper.writeValueAsBytes(compatible);
        }
        return this.mapper.writeValueAsBytes(instance);
    }
}

