/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper;

import com.dremio.jdbc.shaded.org.apache.zookeeper.ClientCnxn;
import com.dremio.jdbc.shaded.org.apache.zookeeper.Testable;
import com.dremio.jdbc.shaded.org.apache.zookeeper.WatchedEvent;
import com.dremio.jdbc.shaded.org.apache.zookeeper.Watcher;
import com.dremio.jdbc.shaded.org.apache.zookeeper.ZooKeeper;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;

class ZooKeeperTestable
implements Testable {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperTestable.class);
    private final ClientCnxn clientCnxn;

    ZooKeeperTestable(ClientCnxn clientCnxn) {
        this.clientCnxn = clientCnxn;
    }

    @Override
    public void injectSessionExpiration() {
        LOG.info("injectSessionExpiration() called");
        this.clientCnxn.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
        this.clientCnxn.eventThread.queueEventOfDeath();
        this.clientCnxn.state = ZooKeeper.States.CLOSED;
        this.clientCnxn.sendThread.getClientCnxnSocket().onClosing();
    }

    @Override
    public void queueEvent(WatchedEvent event) {
        LOG.info("queueEvent() called: {}", (Object)event);
        this.clientCnxn.eventThread.queueEvent(event);
    }
}

