/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.cli;

import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.AddAuthCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.AddWatchCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.CliCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.CloseCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.CreateCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.DelQuotaCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.DeleteAllCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.DeleteCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.GetAclCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.GetAllChildrenNumberCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.GetCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.GetConfigCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.GetEphemeralsCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.ListQuotaCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.LsCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.ReconfigCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.RemoveWatchesCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.SetAclCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.SetCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.SetQuotaCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.StatCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.SyncCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.VersionCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.WhoAmICommand;
import java.util.function.Supplier;

public class CommandFactory {
    public static CliCommand getInstance(Command command) {
        return command.getInstance();
    }

    public static enum Command {
        CLOSE(CloseCommand::new),
        CREATE(CreateCommand::new),
        DELETE(DeleteCommand::new),
        DELETE_ALL(DeleteAllCommand::new),
        SET(SetCommand::new),
        GET(GetCommand::new),
        LS(LsCommand::new),
        GET_ACL(GetAclCommand::new),
        SET_ACL(SetAclCommand::new),
        STAT(StatCommand::new),
        SYNC(SyncCommand::new),
        SET_QUOTA(SetQuotaCommand::new),
        LIST_QUOTA(ListQuotaCommand::new),
        DEL_QUOTA(DelQuotaCommand::new),
        ADD_AUTH(AddAuthCommand::new),
        RECONFIG(ReconfigCommand::new),
        GET_CONFIG(GetConfigCommand::new),
        REMOVE_WATCHES(RemoveWatchesCommand::new),
        GET_EPHEMERALS(GetEphemeralsCommand::new),
        GET_ALL_CHILDREN_NUMBER(GetAllChildrenNumberCommand::new),
        VERSION(VersionCommand::new),
        ADD_WATCH(AddWatchCommand::new),
        WHO_AM_I(WhoAmICommand::new);

        private Supplier<? extends CliCommand> instantiator;

        private CliCommand getInstance() {
            return this.instantiator.get();
        }

        private Command(Supplier<? extends CliCommand> instantiator) {
            this.instantiator = instantiator;
        }
    }
}

