/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.cli;

import com.dremio.jdbc.shaded.org.apache.commons.cli.CommandLine;
import com.dremio.jdbc.shaded.org.apache.commons.cli.DefaultParser;
import com.dremio.jdbc.shaded.org.apache.commons.cli.Options;
import com.dremio.jdbc.shaded.org.apache.commons.cli.ParseException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.KeeperException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.CliCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.CliException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.CliParseException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.CliWrapperException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.StatPrinter;
import com.dremio.jdbc.shaded.org.apache.zookeeper.data.Stat;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.util.ConfigUtils;
import java.nio.charset.StandardCharsets;

public class GetConfigCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public GetConfigCommand() {
        super("config", "[-c] [-w] [-s]");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        DefaultParser parser = new DefaultParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 1) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        byte[] data;
        boolean watch = this.cl.hasOption("w");
        Stat stat = new Stat();
        try {
            data = this.zk.getConfig(watch, stat);
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        byte[] byArray = data = data == null ? "null".getBytes(StandardCharsets.UTF_8) : data;
        if (this.cl.hasOption("c")) {
            this.out.println(ConfigUtils.getClientConfigStr(new String(data, StandardCharsets.UTF_8)));
        } else {
            this.out.println(new String(data, StandardCharsets.UTF_8));
        }
        if (this.cl.hasOption("s")) {
            new StatPrinter(this.out).print(stat);
        }
        return watch;
    }

    static {
        options.addOption("s", false, "stats");
        options.addOption("w", false, "watch");
        options.addOption("c", false, "client connection string");
    }
}

