/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.cli;

import com.dremio.jdbc.shaded.org.apache.commons.cli.CommandLine;
import com.dremio.jdbc.shaded.org.apache.commons.cli.DefaultParser;
import com.dremio.jdbc.shaded.org.apache.commons.cli.Options;
import com.dremio.jdbc.shaded.org.apache.commons.cli.ParseException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.KeeperException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.CliCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.CliException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.CliParseException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.CliWrapperException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.MalformedPathException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.cli.StatPrinter;
import com.dremio.jdbc.shaded.org.apache.zookeeper.data.Stat;
import java.nio.charset.StandardCharsets;

public class SetCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public SetCommand() {
        super("set", "[-s] [-v version] path data");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        DefaultParser parser = new DefaultParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 3) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path = this.args[1];
        byte[] data = this.args[2].getBytes(StandardCharsets.UTF_8);
        int version = this.cl.hasOption("v") ? Integer.parseInt(this.cl.getOptionValue("v")) : -1;
        try {
            Stat stat = this.zk.setData(path, data, version);
            if (this.cl.hasOption("s")) {
                new StatPrinter(this.out).print(stat);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }

    static {
        options.addOption("s", false, "stats");
        options.addOption("v", true, "version");
    }
}

