/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.common;

import com.dremio.jdbc.shaded.org.apache.zookeeper.common.BCFKSFileLoader;
import com.dremio.jdbc.shaded.org.apache.zookeeper.common.FileKeyStoreLoader;
import com.dremio.jdbc.shaded.org.apache.zookeeper.common.JKSFileLoader;
import com.dremio.jdbc.shaded.org.apache.zookeeper.common.KeyStoreFileType;
import com.dremio.jdbc.shaded.org.apache.zookeeper.common.PEMFileLoader;
import com.dremio.jdbc.shaded.org.apache.zookeeper.common.PKCS12FileLoader;
import java.util.Objects;

public class FileKeyStoreLoaderBuilderProvider {
    static FileKeyStoreLoader.Builder<? extends FileKeyStoreLoader> getBuilderForKeyStoreFileType(KeyStoreFileType type) {
        switch (Objects.requireNonNull(type)) {
            case JKS: {
                return new JKSFileLoader.Builder();
            }
            case PEM: {
                return new PEMFileLoader.Builder();
            }
            case PKCS12: {
                return new PKCS12FileLoader.Builder();
            }
            case BCFKS: {
                return new BCFKSFileLoader.Builder();
            }
        }
        throw new AssertionError((Object)("Unexpected StoreFileType: " + type.name()));
    }
}

