/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.common;

import com.dremio.jdbc.shaded.org.apache.zookeeper.common.FileKeyStoreLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;

abstract class StandardTypeFileKeyStoreLoader
extends FileKeyStoreLoader {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    protected final SupportedStandardKeyFormat format;

    StandardTypeFileKeyStoreLoader(String keyStorePath, String trustStorePath, String keyStorePassword, String trustStorePassword, SupportedStandardKeyFormat format) {
        super(keyStorePath, trustStorePath, keyStorePassword, trustStorePassword);
        this.format = format;
    }

    @Override
    public KeyStore loadKeyStore() throws IOException, GeneralSecurityException {
        try (FileInputStream inputStream = new FileInputStream(new File(this.keyStorePath));){
            KeyStore ks = this.keyStoreInstance();
            ks.load(inputStream, StandardTypeFileKeyStoreLoader.passwordStringToCharArray(this.keyStorePassword));
            KeyStore keyStore = ks;
            return keyStore;
        }
    }

    @Override
    public KeyStore loadTrustStore() throws IOException, GeneralSecurityException {
        try (FileInputStream inputStream = new FileInputStream(new File(this.trustStorePath));){
            KeyStore ts = this.keyStoreInstance();
            ts.load(inputStream, StandardTypeFileKeyStoreLoader.passwordStringToCharArray(this.trustStorePassword));
            KeyStore keyStore = ts;
            return keyStore;
        }
    }

    private KeyStore keyStoreInstance() throws KeyStoreException {
        return KeyStore.getInstance(this.format.name());
    }

    private static char[] passwordStringToCharArray(String password) {
        return password == null ? EMPTY_CHAR_ARRAY : password.toCharArray();
    }

    protected static enum SupportedStandardKeyFormat {
        JKS,
        PKCS12,
        BCFKS;

    }
}

