/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.jmx;

import com.dremio.jdbc.shaded.org.apache.zookeeper.jmx.ZKMBeanInfo;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanRegistry {
    public static final String DOMAIN = "com.dremio.jdbc.shaded.org.apache.ZooKeeperService";
    private static final Logger LOG = LoggerFactory.getLogger(MBeanRegistry.class);
    private static volatile MBeanRegistry instance = new MBeanRegistry();
    private final Object LOCK = new Object();
    private Map<ZKMBeanInfo, String> mapBean2Path = new ConcurrentHashMap<ZKMBeanInfo, String>();
    private MBeanServer mBeanServer;

    public static void setInstance(MBeanRegistry instance) {
        MBeanRegistry.instance = instance;
    }

    public static MBeanRegistry getInstance() {
        return instance;
    }

    public MBeanRegistry() {
        try {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Error e) {
            this.mBeanServer = MBeanServerFactory.createMBeanServer();
        }
    }

    public MBeanServer getPlatformMBeanServer() {
        return this.mBeanServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ZKMBeanInfo bean, ZKMBeanInfo parent) throws JMException {
        assert (bean != null);
        String path = null;
        if (parent != null) {
            path = this.mapBean2Path.get(parent);
            assert (path != null);
        }
        path = this.makeFullPath(path, parent);
        if (bean.isHidden()) {
            return;
        }
        ObjectName oname = this.makeObjectName(path, bean);
        try {
            Object object = this.LOCK;
            synchronized (object) {
                this.mBeanServer.registerMBean(bean, oname);
                this.mapBean2Path.put(bean, path);
            }
        }
        catch (JMException e) {
            LOG.warn("Failed to register MBean {}", (Object)bean.getName());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(String path, ZKMBeanInfo bean) throws JMException {
        if (path == null) {
            return;
        }
        if (!bean.isHidden()) {
            ObjectName objName = this.makeObjectName(path, bean);
            LOG.debug("Unregister MBean [{}]", (Object)objName);
            Object object = this.LOCK;
            synchronized (object) {
                this.mBeanServer.unregisterMBean(objName);
            }
        }
    }

    public Set<ZKMBeanInfo> getRegisteredBeans() {
        return new HashSet<ZKMBeanInfo>(this.mapBean2Path.keySet());
    }

    public void unregister(ZKMBeanInfo bean) {
        if (bean == null) {
            return;
        }
        String path = this.mapBean2Path.remove(bean);
        try {
            this.unregister(path, bean);
        }
        catch (JMException e) {
            LOG.warn("Error during unregister of [{}]", (Object)bean.getName(), (Object)e);
        }
        catch (Throwable t2) {
            LOG.error("Unexpected exception during unregister of [{}]. It should be reviewed and fixed.", (Object)bean.getName(), (Object)t2);
        }
    }

    public String makeFullPath(String prefix, String ... name) {
        StringBuilder sb = new StringBuilder(prefix == null ? "/" : (prefix.equals("/") ? prefix : prefix + "/"));
        boolean first = true;
        for (String s2 : name) {
            if (s2 == null) continue;
            if (!first) {
                sb.append("/");
            } else {
                first = false;
            }
            sb.append(s2);
        }
        return sb.toString();
    }

    protected String makeFullPath(String prefix, ZKMBeanInfo bean) {
        return this.makeFullPath(prefix, bean == null ? null : bean.getName());
    }

    private int tokenize(StringBuilder sb, String path, int index) {
        String[] tokens;
        for (String s2 : tokens = path.split("/")) {
            if (s2.length() == 0) continue;
            sb.append("name").append(index++).append("=").append(s2).append(",");
        }
        return index;
    }

    protected ObjectName makeObjectName(String path, ZKMBeanInfo bean) throws MalformedObjectNameException {
        if (path == null) {
            return null;
        }
        StringBuilder beanName = new StringBuilder("com.dremio.jdbc.shaded.org.apache.ZooKeeperService:");
        int counter = 0;
        counter = this.tokenize(beanName, path, counter);
        this.tokenize(beanName, bean.getName(), counter);
        beanName.deleteCharAt(beanName.length() - 1);
        try {
            return new ObjectName(beanName.toString());
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Invalid name \"{}\" for class {}", (Object)beanName, (Object)bean.getClass());
            throw e;
        }
    }
}

