/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.server;

import com.dremio.jdbc.shaded.org.apache.zookeeper.server.persistence.TxnLog;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.persistence.Util;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.Leader;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.QuorumPacket;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Iterator;

public class TxnLogProposalIterator
implements Iterator<Leader.Proposal> {
    private static final Logger LOG = LoggerFactory.getLogger(TxnLogProposalIterator.class);
    public static final TxnLogProposalIterator EMPTY_ITERATOR = new TxnLogProposalIterator();
    private boolean hasNext = false;
    private TxnLog.TxnIterator itr;

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Leader.Proposal next() {
        Leader.Proposal p = new Leader.Proposal();
        try {
            QuorumPacket pp;
            byte[] serializedData = Util.marshallTxnEntry(this.itr.getHeader(), this.itr.getTxn(), this.itr.getDigest());
            p.packet = pp = new QuorumPacket(2, this.itr.getHeader().getZxid(), serializedData, null);
            p.request = null;
            this.hasNext = this.itr.next();
        }
        catch (IOException e) {
            LOG.error("Unable to read txnlog from disk", e);
            this.hasNext = false;
        }
        return p;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.itr != null) {
            try {
                this.itr.close();
            }
            catch (IOException ioe) {
                LOG.warn("Error closing file iterator", ioe);
            }
        }
    }

    private TxnLogProposalIterator() {
    }

    public TxnLogProposalIterator(TxnLog.TxnIterator itr) {
        if (itr != null) {
            this.itr = itr;
            this.hasNext = itr.getHeader() != null;
        }
    }
}

