/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.server;

import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ExitCode;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ServerMetrics;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ZooKeeperServerListener;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ZooKeeperThread;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;

public class ZooKeeperCriticalThread
extends ZooKeeperThread {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperCriticalThread.class);
    private final ZooKeeperServerListener listener;

    public ZooKeeperCriticalThread(String threadName, ZooKeeperServerListener listener) {
        super(threadName);
        this.listener = listener;
    }

    @Override
    protected void handleException(String threadName, Throwable e) {
        LOG.error("Severe unrecoverable error, from thread : {}", (Object)threadName, (Object)e);
        this.listener.notifyStopping(threadName, ExitCode.UNEXPECTED_ERROR.getValue());
        ServerMetrics.getMetrics().UNRECOVERABLE_ERROR_COUNT.add(1L);
    }
}

