/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.server.admin;

import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.admin.CommandOutputter;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.admin.CommandResponse;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.PrintWriter;

public class JsonOutputter
implements CommandOutputter {
    static final Logger LOG = LoggerFactory.getLogger(JsonOutputter.class);
    public static final String ERROR_RESPONSE = "{\"error\": \"Exception writing command response to JSON\"}";
    private ObjectMapper mapper = new ObjectMapper();

    public JsonOutputter() {
        this.mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        this.mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.mapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public void output(CommandResponse response, PrintWriter pw) {
        try {
            this.mapper.writeValue(pw, response.toMap());
        }
        catch (JsonGenerationException e) {
            LOG.warn("Exception writing command response to JSON:", e);
            pw.write(ERROR_RESPONSE);
        }
        catch (JsonMappingException e) {
            LOG.warn("Exception writing command response to JSON:", e);
            pw.write(ERROR_RESPONSE);
        }
        catch (IOException e) {
            LOG.warn("Exception writing command response to JSON:", e);
            pw.write(ERROR_RESPONSE);
        }
    }
}

