/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.server.auth;

import com.dremio.jdbc.shaded.org.apache.zookeeper.KeeperException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.data.Id;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ServerCnxn;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.auth.AuthenticationProvider;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DigestAuthenticationProvider.class);
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA1";
    public static final String DIGEST_ALGORITHM_KEY = "zookeeper.DigestAuthenticationProvider.digestAlg";
    private static final String DIGEST_ALGORITHM = System.getProperty("zookeeper.DigestAuthenticationProvider.digestAlg", "SHA1");
    private static final String DIGEST_AUTH_ENABLED = "zookeeper.DigestAuthenticationProvider.enabled";
    private static final String superDigest;

    public static boolean isEnabled() {
        boolean enabled = Boolean.parseBoolean(System.getProperty(DIGEST_AUTH_ENABLED, "true"));
        LOG.info("{} = {}", (Object)DIGEST_AUTH_ENABLED, (Object)enabled);
        return enabled;
    }

    @Override
    public String getScheme() {
        return "digest";
    }

    private static String base64Encode(byte[] b) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < b.length) {
            int pad = 0;
            int v = (b[i++] & 0xFF) << 16;
            if (i < b.length) {
                v |= (b[i++] & 0xFF) << 8;
            } else {
                ++pad;
            }
            if (i < b.length) {
                v |= b[i++] & 0xFF;
            } else {
                ++pad;
            }
            sb.append(DigestAuthenticationProvider.encode(v >> 18));
            sb.append(DigestAuthenticationProvider.encode(v >> 12));
            if (pad < 2) {
                sb.append(DigestAuthenticationProvider.encode(v >> 6));
            } else {
                sb.append('=');
            }
            if (pad < 1) {
                sb.append(DigestAuthenticationProvider.encode(v));
                continue;
            }
            sb.append('=');
        }
        return sb.toString();
    }

    private static char encode(int i) {
        if ((i &= 0x3F) < 26) {
            return (char)(65 + i);
        }
        if (i < 52) {
            return (char)(97 + i - 26);
        }
        if (i < 62) {
            return (char)(48 + i - 52);
        }
        return i == 62 ? (char)'+' : '/';
    }

    public static String generateDigest(String idPassword) throws NoSuchAlgorithmException {
        String[] parts = idPassword.split(":", 2);
        byte[] digest = DigestAuthenticationProvider.digest(idPassword);
        return parts[0] + ":" + DigestAuthenticationProvider.base64Encode(digest);
    }

    public static byte[] digest(String idPassword) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(DIGEST_ALGORITHM).digest(idPassword.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerCnxn cnxn, byte[] authData) {
        String id = new String(authData);
        try {
            String digest = DigestAuthenticationProvider.generateDigest(id);
            if (digest.equals(superDigest)) {
                cnxn.addAuthInfo(new Id("super", ""));
            }
            cnxn.addAuthInfo(new Id(this.getScheme(), digest));
            return KeeperException.Code.OK;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Missing algorithm", e);
            return KeeperException.Code.AUTHFAILED;
        }
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public boolean isValid(String id) {
        String[] parts = id.split(":");
        return parts.length == 2;
    }

    @Override
    public boolean matches(String id, String aclExpr) {
        return id.equals(aclExpr);
    }

    @Override
    public String getUserName(String id) {
        return id.split(":")[0];
    }

    public static void main(String[] args) throws NoSuchAlgorithmException {
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i] + "->" + DigestAuthenticationProvider.generateDigest(args[i]));
        }
    }

    static {
        try {
            DigestAuthenticationProvider.generateDigest(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("don't support this ACL digest algorithm: " + DIGEST_ALGORITHM + " in the current environment");
        }
        LOG.info("ACL digest algorithm is: {}", (Object)DIGEST_ALGORITHM);
        superDigest = System.getProperty("zookeeper.DigestAuthenticationProvider.superDigest");
    }
}

