/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.server.command;

import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ServerCnxn;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class AbstractFourLetterCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFourLetterCommand.class);
    public static final String ZK_NOT_SERVING = "This ZooKeeper instance is not currently serving requests";
    protected PrintWriter pw;
    protected ServerCnxn serverCnxn;
    protected ZooKeeperServer zkServer;
    protected ServerCnxnFactory factory;

    public AbstractFourLetterCommand(PrintWriter pw, ServerCnxn serverCnxn) {
        this.pw = pw;
        this.serverCnxn = serverCnxn;
    }

    public void start() {
        this.run();
    }

    public void run() {
        try {
            this.commandRun();
        }
        catch (IOException ie) {
            LOG.error("Error in running command ", ie);
        }
        finally {
            this.serverCnxn.cleanupWriterSocket(this.pw);
        }
    }

    public void setZkServer(ZooKeeperServer zkServer) {
        this.zkServer = zkServer;
    }

    boolean isZKServerRunning() {
        return this.zkServer != null && this.zkServer.isRunning();
    }

    public void setFactory(ServerCnxnFactory factory) {
        this.factory = factory;
    }

    public abstract void commandRun() throws IOException;
}

