/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.server.command;

import com.dremio.jdbc.shaded.org.apache.zookeeper.Version;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ServerCnxn;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ServerStats;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.command.AbstractFourLetterCommand;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.command.FourLetterCommands;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.BufferStats;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.Leader;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.PrintWriter;

public class StatCommand
extends AbstractFourLetterCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFourLetterCommand.class);
    private int len;

    public StatCommand(PrintWriter pw, ServerCnxn serverCnxn, int len) {
        super(pw, serverCnxn);
        this.len = len;
    }

    @Override
    public void commandRun() {
        if (!this.isZKServerRunning()) {
            this.pw.println("This ZooKeeper instance is not currently serving requests");
        } else {
            this.pw.print("Zookeeper version: ");
            this.pw.println(Version.getFullVersion());
            if (this.zkServer instanceof ReadOnlyZooKeeperServer) {
                this.pw.println("READ-ONLY mode; serving only read-only clients");
            }
            if (this.len == FourLetterCommands.statCmd) {
                LOG.info("Stat command output");
                this.pw.println("Clients:");
                for (ServerCnxn c : this.factory.getConnections()) {
                    c.dumpConnectionInfo(this.pw, true);
                    this.pw.println();
                }
                this.pw.println();
            }
            ServerStats serverStats = this.zkServer.serverStats();
            this.pw.print(serverStats.toString());
            this.pw.print("Node count: ");
            this.pw.println(this.zkServer.getZKDatabase().getNodeCount());
            if (serverStats.getServerState().equals("leader")) {
                Leader leader = ((LeaderZooKeeperServer)this.zkServer).getLeader();
                BufferStats proposalStats = leader.getProposalStats();
                this.pw.printf("Proposal sizes last/min/max: %s%n", proposalStats.toString());
            }
        }
    }
}

