/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.server.controller;

import com.dremio.jdbc.shaded.org.apache.jute.BinaryInputArchive;
import com.dremio.jdbc.shaded.org.apache.jute.Record;
import com.dremio.jdbc.shaded.org.apache.zookeeper.KeeperException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.proto.ReplyHeader;
import com.dremio.jdbc.shaded.org.apache.zookeeper.proto.RequestHeader;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ByteBufferInputStream;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.NIOServerCnxn;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.NIOServerCnxnFactory;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.controller.ControllableConnectionFactory;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

@SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="factory is ControllableConnectionFactory type.")
public class ControllableConnection
extends NIOServerCnxn {
    private static final Logger LOG = LoggerFactory.getLogger(ControllableConnection.class);
    private final ControllableConnectionFactory controller;

    public ControllableConnection(ZooKeeperServer zk, SocketChannel sock, SelectionKey sk, NIOServerCnxnFactory factory, NIOServerCnxnFactory.SelectorThread selectorThread) throws IOException {
        super(zk, sock, sk, factory, selectorThread);
        this.controller = (ControllableConnectionFactory)factory;
    }

    @Override
    public int sendResponse(ReplyHeader header, Record record, String tag) {
        if (this.controller.shouldSendResponse()) {
            try {
                return super.sendResponse(header, record, tag);
            }
            catch (IOException ex) {
                LOG.warn("IO Exception occurred", ex);
            }
        } else {
            LOG.warn("Controller is configured to NOT sending response back to client.");
        }
        return -1;
    }

    @Override
    protected void readRequest() throws IOException {
        if (this.controller.shouldFailNextRequest()) {
            ByteBuffer buffer = this.incomingBuffer.slice();
            BinaryInputArchive bia = BinaryInputArchive.getArchive(new ByteBufferInputStream(buffer));
            RequestHeader h2 = new RequestHeader();
            h2.deserialize(bia, "header");
            super.sendResponse(new ReplyHeader(h2.getXid(), 0L, KeeperException.Code.APIERROR.intValue()), null, null);
        } else {
            this.controller.delayRequestIfNeeded();
            super.readRequest();
        }
    }
}

