/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum;

import com.dremio.jdbc.shaded.org.apache.jute.Record;
import com.dremio.jdbc.shaded.org.apache.zookeeper.jmx.MBeanRegistry;
import com.dremio.jdbc.shaded.org.apache.zookeeper.metrics.MetricsContext;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ExitCode;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.FinalRequestProcessor;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.Request;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ServerMetrics;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ZKDatabase;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.CommitProcessor;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.Follower;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.FollowerRequestProcessor;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.Learner;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.LearnerHandlerBean;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.LearnerSyncRequest;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.QuorumPacket;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.SendAckRequestProcessor;
import com.dremio.jdbc.shaded.org.apache.zookeeper.txn.TxnDigest;
import com.dremio.jdbc.shaded.org.apache.zookeeper.txn.TxnHeader;
import com.dremio.jdbc.shaded.org.apache.zookeeper.util.ServiceUtils;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.management.JMException;

public class FollowerZooKeeperServer
extends LearnerZooKeeperServer {
    private static final Logger LOG = LoggerFactory.getLogger(FollowerZooKeeperServer.class);
    ConcurrentLinkedQueue<Request> pendingSyncs;
    LinkedBlockingQueue<Request> pendingTxns = new LinkedBlockingQueue();

    FollowerZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, self.clientPortListenBacklog, zkDb, self);
        this.pendingSyncs = new ConcurrentLinkedQueue();
    }

    public Follower getFollower() {
        return this.self.follower;
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        this.commitProcessor = new CommitProcessor(finalProcessor, Long.toString(this.getServerId()), true, this.getZooKeeperServerListener());
        this.commitProcessor.start();
        this.firstProcessor = new FollowerRequestProcessor(this, this.commitProcessor);
        ((FollowerRequestProcessor)this.firstProcessor).start();
        this.syncProcessor = new SyncRequestProcessor(this, new SendAckRequestProcessor(this.getFollower()));
        this.syncProcessor.start();
    }

    public void logRequest(TxnHeader hdr, Record txn, TxnDigest digest) {
        Request request = new Request(hdr.getClientId(), hdr.getCxid(), hdr.getType(), hdr, txn, hdr.getZxid());
        request.setTxnDigest(digest);
        if ((request.zxid & 0xFFFFFFFFL) != 0L) {
            this.pendingTxns.add(request);
        }
        this.syncProcessor.processRequest(request);
    }

    public void commit(long zxid) {
        if (this.pendingTxns.size() == 0) {
            LOG.warn("Committing " + Long.toHexString(zxid) + " without seeing txn");
            return;
        }
        long firstElementZxid = ((Request)this.pendingTxns.element()).zxid;
        if (firstElementZxid != zxid) {
            LOG.error("Committing zxid 0x" + Long.toHexString(zxid) + " but next pending txn 0x" + Long.toHexString(firstElementZxid));
            ServiceUtils.requestSystemExit(ExitCode.UNMATCHED_TXN_COMMIT.getValue());
        }
        Request request = (Request)this.pendingTxns.remove();
        request.logLatency(ServerMetrics.getMetrics().COMMIT_PROPAGATION_LATENCY);
        this.commitProcessor.commit(request);
    }

    public synchronized void sync() {
        if (this.pendingSyncs.size() == 0) {
            LOG.warn("Not expecting a sync.");
            return;
        }
        Request r = (Request)this.pendingSyncs.remove();
        if (r instanceof LearnerSyncRequest) {
            LearnerSyncRequest lsr = (LearnerSyncRequest)r;
            lsr.fh.queuePacket(new QuorumPacket(7, 0L, null, null));
        }
        this.commitProcessor.commit(r);
    }

    @Override
    public int getGlobalOutstandingLimit() {
        int divisor = this.self.getQuorumSize() > 2 ? this.self.getQuorumSize() - 1 : 1;
        int globalOutstandingLimit = super.getGlobalOutstandingLimit() / divisor;
        return globalOutstandingLimit;
    }

    @Override
    public String getState() {
        return "follower";
    }

    @Override
    public Learner getLearner() {
        return this.getFollower();
    }

    void processObserverRequest(Request request) {
        ((FollowerRequestProcessor)this.firstProcessor).processRequest(request, false);
    }

    boolean registerJMX(LearnerHandlerBean handlerBean) {
        try {
            MBeanRegistry.getInstance().register(handlerBean, this.jmxServerBean);
            return true;
        }
        catch (JMException e) {
            LOG.warn("Could not register connection", e);
            return false;
        }
    }

    @Override
    protected void registerMetrics() {
        super.registerMetrics();
        MetricsContext rootContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        rootContext.registerGauge("synced_observers", this.self::getSynced_observers_metric);
    }

    @Override
    protected void unregisterMetrics() {
        super.unregisterMetrics();
        MetricsContext rootContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        rootContext.unregisterGauge("synced_observers");
    }
}

