/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum;

import com.dremio.jdbc.shaded.org.apache.zookeeper.KeeperException;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.Request;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.RequestProcessor;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import com.dremio.jdbc.shaded.org.apache.zookeeper.txn.ErrorTxn;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;

public class LeaderRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderRequestProcessor.class);
    private final LeaderZooKeeperServer lzks;
    private final RequestProcessor nextProcessor;

    public LeaderRequestProcessor(LeaderZooKeeperServer zks, RequestProcessor nextProcessor) {
        this.lzks = zks;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
        if (!this.lzks.authWriteRequest(request)) {
            return;
        }
        Request upgradeRequest = null;
        try {
            upgradeRequest = this.lzks.checkUpgradeSession(request);
        }
        catch (KeeperException ke) {
            if (request.getHdr() != null) {
                LOG.debug("Updating header");
                request.getHdr().setType(-1);
                request.setTxn(new ErrorTxn(ke.code().intValue()));
            }
            request.setException(ke);
            LOG.warn("Error creating upgrade request", ke);
        }
        catch (IOException ie) {
            LOG.error("Unexpected error in upgrade", ie);
        }
        if (upgradeRequest != null) {
            this.nextProcessor.processRequest(upgradeRequest);
        }
        this.nextProcessor.processRequest(request);
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down");
        this.nextProcessor.shutdown();
    }
}

