/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum;

import com.dremio.jdbc.shaded.org.apache.zookeeper.common.NetUtils;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ServerCnxnHelper;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.LocalPeerMXBean;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.ServerBean;
import java.util.stream.Collectors;

public class LocalPeerBean
extends ServerBean
implements LocalPeerMXBean {
    private final QuorumPeer peer;

    public LocalPeerBean(QuorumPeer peer) {
        this.peer = peer;
    }

    @Override
    public String getName() {
        return "replica." + this.peer.getMyId();
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public int getTickTime() {
        return this.peer.getTickTime();
    }

    @Override
    public int getMaxClientCnxnsPerHost() {
        return this.peer.getMaxClientCnxnsPerHost();
    }

    @Override
    public int getMinSessionTimeout() {
        return this.peer.getMinSessionTimeout();
    }

    @Override
    public int getMaxSessionTimeout() {
        return this.peer.getMaxSessionTimeout();
    }

    @Override
    public int getInitLimit() {
        return this.peer.getInitLimit();
    }

    @Override
    public int getSyncLimit() {
        return this.peer.getSyncLimit();
    }

    @Override
    public void setInitLimit(int initLimit) {
        this.peer.setInitLimit(initLimit);
    }

    @Override
    public void setSyncLimit(int syncLimit) {
        this.peer.setSyncLimit(syncLimit);
    }

    @Override
    public int getTick() {
        return this.peer.getTick();
    }

    @Override
    public String getState() {
        return this.peer.getServerState();
    }

    @Override
    public String getQuorumAddress() {
        return this.peer.getQuorumAddress().getAllAddresses().stream().map(NetUtils::formatInetAddr).collect(Collectors.joining("|"));
    }

    @Override
    public int getElectionType() {
        return this.peer.getElectionType();
    }

    @Override
    public String getElectionAddress() {
        return this.peer.getElectionAddress().getAllAddresses().stream().map(NetUtils::formatInetAddr).collect(Collectors.joining("|"));
    }

    @Override
    public String getClientAddress() {
        if (null != this.peer.cnxnFactory) {
            return NetUtils.formatInetAddr(this.peer.cnxnFactory.getLocalAddress());
        }
        return "";
    }

    @Override
    public String getLearnerType() {
        return this.peer.getLearnerType().toString();
    }

    @Override
    public long getConfigVersion() {
        return this.peer.getQuorumVerifier().getVersion();
    }

    @Override
    public String getQuorumSystemInfo() {
        return this.peer.getQuorumVerifier().toString();
    }

    @Override
    public boolean isPartOfEnsemble() {
        return this.peer.getView().containsKey(this.peer.getMyId());
    }

    @Override
    public boolean isLeader() {
        return this.peer.isLeader(this.peer.getMyId());
    }

    @Override
    public int getMaxCnxns() {
        return ServerCnxnHelper.getMaxCnxns(this.peer.secureCnxnFactory, this.peer.cnxnFactory);
    }
}

