/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum;

import com.dremio.jdbc.shaded.org.apache.zookeeper.jmx.MBeanRegistry;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.DataTreeBean;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.FinalRequestProcessor;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.PrepRequestProcessor;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.Request;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ServerCnxn;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ZKDatabase;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ZooKeeperServerBean;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.LearnerSessionTracker;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.LocalPeerBean;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.ReadOnlyBean;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.ReadOnlyRequestProcessor;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.UpgradeableSessionTracker;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.stream.Collectors;

public class ReadOnlyZooKeeperServer
extends ZooKeeperServer {
    protected final QuorumPeer self;
    private volatile boolean shutdown = false;

    ReadOnlyZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZKDatabase zkDb) {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, self.clientPortListenBacklog, zkDb, self.getInitialConfig(), self.isReconfigEnabled());
        this.self = self;
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        PrepRequestProcessor prepProcessor = new PrepRequestProcessor(this, finalProcessor);
        prepProcessor.start();
        this.firstProcessor = new ReadOnlyRequestProcessor(this, prepProcessor);
        ((ReadOnlyRequestProcessor)this.firstProcessor).start();
    }

    @Override
    public synchronized void startup() {
        if (this.shutdown) {
            LOG.warn("Not starting Read-only server as startup follows shutdown!");
            return;
        }
        this.registerJMX(new ReadOnlyBean(this), this.self.jmxLocalPeerBean);
        super.startup();
        this.self.setZooKeeperServer(this);
        this.self.adminServer.setZooKeeperServer(this);
        LOG.info("Read-only server started");
    }

    @Override
    public void createSessionTracker() {
        this.sessionTracker = new LearnerSessionTracker(this, this.getZKDatabase().getSessionWithTimeOuts(), this.tickTime, this.self.getMyId(), this.self.areLocalSessionsEnabled(), this.getZooKeeperServerListener());
    }

    @Override
    protected void startSessionTracker() {
        ((LearnerSessionTracker)this.sessionTracker).start();
    }

    @Override
    protected void setLocalSessionFlag(Request si) {
        switch (si.type) {
            case -10: {
                if (!this.self.areLocalSessionsEnabled()) break;
                si.setLocalSession(true);
                break;
            }
            case -11: {
                if (((UpgradeableSessionTracker)this.sessionTracker).isLocalSession(si.sessionId)) {
                    si.setLocalSession(true);
                    break;
                }
                LOG.warn("Submitting global closeSession request for session 0x{} in ReadOnly mode", (Object)Long.toHexString(si.sessionId));
                break;
            }
        }
    }

    @Override
    protected void validateSession(ServerCnxn cnxn, long sessionId) throws IOException {
        if (((LearnerSessionTracker)this.sessionTracker).isGlobalSession(sessionId)) {
            String msg = "Refusing global session reconnection in RO mode " + cnxn.getRemoteSocketAddress();
            LOG.info(msg);
            throw new ServerCnxn.CloseRequestException(msg, ServerCnxn.DisconnectReason.RENEW_GLOBAL_SESSION_IN_RO_MODE);
        }
    }

    @Override
    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(ZooKeeperServerBean serverBean, LocalPeerBean localPeerBean) {
        try {
            this.jmxServerBean = serverBean;
            MBeanRegistry.getInstance().register(serverBean, localPeerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxServerBean = null;
        }
    }

    @Override
    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", e);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(ZooKeeperServer zks) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", e);
        }
        this.jmxServerBean = null;
    }

    @Override
    public String getState() {
        return "read-only";
    }

    @Override
    public long getServerId() {
        return this.self.getMyId();
    }

    @Override
    public synchronized void shutdown() {
        if (!this.canShutdown()) {
            LOG.debug("ZooKeeper server is not running, so not proceeding to shutdown!");
            return;
        }
        this.shutdown = true;
        this.unregisterJMX(this);
        this.self.setZooKeeperServer(null);
        this.self.closeAllConnections();
        this.self.adminServer.setZooKeeperServer(null);
        super.shutdown();
    }

    @Override
    public void dumpConf(PrintWriter pwriter) {
        super.dumpConf(pwriter);
        pwriter.print("initLimit=");
        pwriter.println(this.self.getInitLimit());
        pwriter.print("syncLimit=");
        pwriter.println(this.self.getSyncLimit());
        pwriter.print("electionAlg=");
        pwriter.println(this.self.getElectionType());
        pwriter.print("electionPort=");
        pwriter.println(this.self.getElectionAddress().getAllPorts().stream().map(Objects::toString).collect(Collectors.joining("|")));
        pwriter.print("quorumPort=");
        pwriter.println(this.self.getQuorumAddress().getAllPorts().stream().map(Objects::toString).collect(Collectors.joining("|")));
        pwriter.print("peerType=");
        pwriter.println(this.self.getLearnerType().ordinal());
    }

    @Override
    protected void setState(ZooKeeperServer.State state) {
        this.state = state;
    }
}

