/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum;

import com.dremio.jdbc.shaded.org.apache.zookeeper.common.NetUtils;
import com.dremio.jdbc.shaded.org.apache.zookeeper.jmx.ZKMBeanInfo;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.quorum.RemotePeerMXBean;
import java.util.stream.Collectors;

public class RemotePeerBean
implements RemotePeerMXBean,
ZKMBeanInfo {
    private QuorumPeer.QuorumServer peer;
    private final QuorumPeer localPeer;

    public RemotePeerBean(QuorumPeer localPeer, QuorumPeer.QuorumServer peer) {
        this.peer = peer;
        this.localPeer = localPeer;
    }

    public void setQuorumServer(QuorumPeer.QuorumServer peer) {
        this.peer = peer;
    }

    @Override
    public String getName() {
        return "replica." + this.peer.id;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String getQuorumAddress() {
        return this.peer.addr.getAllAddresses().stream().map(NetUtils::formatInetAddr).collect(Collectors.joining("|"));
    }

    @Override
    public String getElectionAddress() {
        return this.peer.electionAddr.getAllAddresses().stream().map(NetUtils::formatInetAddr).collect(Collectors.joining("|"));
    }

    @Override
    public String getClientAddress() {
        if (null == this.peer.clientAddr) {
            return "";
        }
        return NetUtils.formatInetAddr(this.peer.clientAddr);
    }

    @Override
    public String getLearnerType() {
        return this.peer.type.toString();
    }

    @Override
    public boolean isLeader() {
        return this.localPeer.isLeader(this.peer.getId());
    }
}

