/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.server.util;

import com.dremio.jdbc.shaded.org.apache.zookeeper.data.ClientInfo;
import com.dremio.jdbc.shaded.org.apache.zookeeper.data.Id;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.auth.AuthenticationProvider;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.auth.ProviderRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class AuthUtil {
    private AuthUtil() {
    }

    public static String getUser(Id id) {
        AuthenticationProvider provider = ProviderRegistry.getProvider(id.getScheme());
        return provider == null ? null : provider.getUserName(id.getId());
    }

    public static String getUsers(List<Id> authInfo) {
        if (authInfo == null) {
            return null;
        }
        String formatted = authInfo.stream().map(AuthUtil::getUser).filter(name -> name != null && !name.trim().isEmpty()).collect(Collectors.joining(","));
        return formatted.isEmpty() ? null : formatted;
    }

    public static List<ClientInfo> getClientInfos(List<Id> authInfo) {
        ArrayList<ClientInfo> clientAuthInfo = new ArrayList<ClientInfo>(authInfo.size());
        authInfo.forEach(id -> {
            String user = AuthUtil.getUser(id);
            clientAuthInfo.add(new ClientInfo(id.getScheme(), user == null ? "" : user));
        });
        return clientAuthInfo;
    }
}

