/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.zookeeper.server.watch;

import com.dremio.jdbc.shaded.org.apache.zookeeper.WatchedEvent;
import com.dremio.jdbc.shaded.org.apache.zookeeper.Watcher;
import com.dremio.jdbc.shaded.org.apache.zookeeper.data.ACL;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ServerCnxn;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ServerMetrics;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ServerWatcher;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.ZooTrace;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.watch.IWatchManager;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.watch.PathParentIterator;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.watch.WatcherMode;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.watch.WatcherModeManager;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.watch.WatcherOrBitSet;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.watch.WatchesPathReport;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.watch.WatchesReport;
import com.dremio.jdbc.shaded.org.apache.zookeeper.server.watch.WatchesSummary;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WatchManager
implements IWatchManager {
    private static final Logger LOG = LoggerFactory.getLogger(WatchManager.class);
    private final Map<String, Set<Watcher>> watchTable = new HashMap<String, Set<Watcher>>();
    private final Map<Watcher, Set<String>> watch2Paths = new HashMap<Watcher, Set<String>>();
    private final WatcherModeManager watcherModeManager = new WatcherModeManager();

    @Override
    public synchronized int size() {
        int result = 0;
        for (Set<Watcher> watches : this.watchTable.values()) {
            result += watches.size();
        }
        return result;
    }

    private boolean isDeadWatcher(Watcher watcher) {
        return watcher instanceof ServerCnxn && ((ServerCnxn)watcher).isStale();
    }

    @Override
    public boolean addWatch(String path, Watcher watcher) {
        return this.addWatch(path, watcher, WatcherMode.DEFAULT_WATCHER_MODE);
    }

    @Override
    public synchronized boolean addWatch(String path, Watcher watcher, WatcherMode watcherMode) {
        if (this.isDeadWatcher(watcher)) {
            LOG.debug("Ignoring addWatch with closed cnxn");
            return false;
        }
        Set<Watcher> list = this.watchTable.get(path);
        if (list == null) {
            list = new HashSet<Watcher>(4);
            this.watchTable.put(path, list);
        }
        list.add(watcher);
        Set<String> paths = this.watch2Paths.get(watcher);
        if (paths == null) {
            paths = new HashSet<String>();
            this.watch2Paths.put(watcher, paths);
        }
        this.watcherModeManager.setWatcherMode(watcher, path, watcherMode);
        return paths.add(path);
    }

    @Override
    public synchronized void removeWatcher(Watcher watcher) {
        Set<String> paths = this.watch2Paths.remove(watcher);
        if (paths == null) {
            return;
        }
        for (String p : paths) {
            Set<Watcher> list = this.watchTable.get(p);
            if (list != null) {
                list.remove(watcher);
                if (list.isEmpty()) {
                    this.watchTable.remove(p);
                }
            }
            this.watcherModeManager.removeWatcher(watcher, p);
        }
    }

    @Override
    public WatcherOrBitSet triggerWatch(String path, Watcher.Event.EventType type, List<ACL> acl) {
        return this.triggerWatch(path, type, acl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WatcherOrBitSet triggerWatch(String path, Watcher.Event.EventType type, List<ACL> acl, WatcherOrBitSet supress) {
        WatchedEvent e = new WatchedEvent(type, Watcher.Event.KeeperState.SyncConnected, path);
        HashSet<Watcher> watchers = new HashSet<Watcher>();
        PathParentIterator pathParentIterator = this.getPathParentIterator(path);
        WatchManager watchManager = this;
        synchronized (watchManager) {
            for (String localPath : pathParentIterator.asIterable()) {
                Set<Watcher> thisWatchers = this.watchTable.get(localPath);
                if (thisWatchers == null || thisWatchers.isEmpty()) continue;
                Iterator<Watcher> iterator = thisWatchers.iterator();
                while (iterator.hasNext()) {
                    Watcher watcher = iterator.next();
                    WatcherMode watcherMode = this.watcherModeManager.getWatcherMode(watcher, localPath);
                    if (watcherMode.isRecursive()) {
                        if (type == Watcher.Event.EventType.NodeChildrenChanged) continue;
                        watchers.add(watcher);
                        continue;
                    }
                    if (pathParentIterator.atParentPath()) continue;
                    watchers.add(watcher);
                    if (watcherMode.isPersistent()) continue;
                    iterator.remove();
                    Set<String> paths = this.watch2Paths.get(watcher);
                    if (paths == null) continue;
                    paths.remove(localPath);
                }
                if (!thisWatchers.isEmpty()) continue;
                this.watchTable.remove(localPath);
            }
        }
        if (watchers.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                ZooTrace.logTraceMessage(LOG, 64L, "No watchers for " + path);
            }
            return null;
        }
        for (Watcher w : watchers) {
            if (supress != null && supress.contains(w)) continue;
            if (w instanceof ServerWatcher) {
                ((ServerWatcher)w).process(e, acl);
                continue;
            }
            w.process(e);
        }
        switch (type) {
            case NodeCreated: {
                ServerMetrics.getMetrics().NODE_CREATED_WATCHER.add(watchers.size());
                break;
            }
            case NodeDeleted: {
                ServerMetrics.getMetrics().NODE_DELETED_WATCHER.add(watchers.size());
                break;
            }
            case NodeDataChanged: {
                ServerMetrics.getMetrics().NODE_CHANGED_WATCHER.add(watchers.size());
                break;
            }
            case NodeChildrenChanged: {
                ServerMetrics.getMetrics().NODE_CHILDREN_WATCHER.add(watchers.size());
                break;
            }
        }
        return new WatcherOrBitSet(watchers);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.watch2Paths.size()).append(" connections watching ").append(this.watchTable.size()).append(" paths\n");
        int total = 0;
        for (Set<String> paths : this.watch2Paths.values()) {
            total += paths.size();
        }
        sb.append("Total watches:").append(total);
        return sb.toString();
    }

    @Override
    public synchronized void dumpWatches(PrintWriter pwriter, boolean byPath) {
        if (byPath) {
            for (Map.Entry<String, Set<Watcher>> e : this.watchTable.entrySet()) {
                pwriter.println(e.getKey());
                for (Watcher w : e.getValue()) {
                    pwriter.print("\t0x");
                    pwriter.print(Long.toHexString(((ServerCnxn)w).getSessionId()));
                    pwriter.print("\n");
                }
            }
        } else {
            for (Map.Entry<Watcher, Set<String>> e : this.watch2Paths.entrySet()) {
                pwriter.print("0x");
                pwriter.println(Long.toHexString(((ServerCnxn)e.getKey()).getSessionId()));
                for (String path : e.getValue()) {
                    pwriter.print("\t");
                    pwriter.println(path);
                }
            }
        }
    }

    @Override
    public synchronized boolean containsWatcher(String path, Watcher watcher) {
        WatcherMode watcherMode = this.watcherModeManager.getWatcherMode(watcher, path);
        PathParentIterator pathParentIterator = this.getPathParentIterator(path);
        for (String localPath : pathParentIterator.asIterable()) {
            Set<Watcher> watchers = this.watchTable.get(localPath);
            if (!pathParentIterator.atParentPath() && watchers != null) {
                return true;
            }
            if (!watcherMode.isRecursive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeWatcher(String path, Watcher watcher) {
        Set<String> paths = this.watch2Paths.get(watcher);
        if (paths == null || !paths.remove(path)) {
            return false;
        }
        Set<Watcher> list = this.watchTable.get(path);
        if (list == null || !list.remove(watcher)) {
            return false;
        }
        if (list.isEmpty()) {
            this.watchTable.remove(path);
        }
        this.watcherModeManager.removeWatcher(watcher, path);
        return true;
    }

    @Override
    public synchronized WatchesReport getWatches() {
        HashMap<Long, Set<String>> id2paths = new HashMap<Long, Set<String>>();
        for (Map.Entry<Watcher, Set<String>> e : this.watch2Paths.entrySet()) {
            Long id = ((ServerCnxn)e.getKey()).getSessionId();
            HashSet paths = new HashSet(e.getValue());
            id2paths.put(id, paths);
        }
        return new WatchesReport(id2paths);
    }

    @Override
    public synchronized WatchesPathReport getWatchesByPath() {
        HashMap<String, Set<Long>> path2ids = new HashMap<String, Set<Long>>();
        for (Map.Entry<String, Set<Watcher>> e : this.watchTable.entrySet()) {
            HashSet<Long> ids = new HashSet<Long>(e.getValue().size());
            path2ids.put(e.getKey(), ids);
            for (Watcher watcher : e.getValue()) {
                ids.add(((ServerCnxn)watcher).getSessionId());
            }
        }
        return new WatchesPathReport(path2ids);
    }

    @Override
    public synchronized WatchesSummary getWatchesSummary() {
        int totalWatches = 0;
        for (Set<String> paths : this.watch2Paths.values()) {
            totalWatches += paths.size();
        }
        return new WatchesSummary(this.watch2Paths.size(), this.watchTable.size(), totalWatches);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public int getRecursiveWatchQty() {
        return this.watcherModeManager.getRecursiveQty();
    }

    private PathParentIterator getPathParentIterator(String path) {
        if (this.watcherModeManager.getRecursiveQty() == 0) {
            return PathParentIterator.forPathOnly(path);
        }
        return PathParentIterator.forAll(path);
    }
}

