/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.bouncycastle.asn1.x509;

import com.dremio.jdbc.shaded.org.bouncycastle.asn1.ASN1Object;
import com.dremio.jdbc.shaded.org.bouncycastle.asn1.ASN1OctetString;
import com.dremio.jdbc.shaded.org.bouncycastle.asn1.ASN1Primitive;
import com.dremio.jdbc.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import com.dremio.jdbc.shaded.org.bouncycastle.asn1.DEROctetString;
import com.dremio.jdbc.shaded.org.bouncycastle.asn1.x509.Extension;
import com.dremio.jdbc.shaded.org.bouncycastle.asn1.x509.Extensions;
import com.dremio.jdbc.shaded.org.bouncycastle.util.Arrays;

public class SubjectKeyIdentifier
extends ASN1Object {
    private byte[] keyidentifier;

    public static SubjectKeyIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SubjectKeyIdentifier.getInstance(ASN1OctetString.getInstance(aSN1TaggedObject, bl));
    }

    public static SubjectKeyIdentifier getInstance(Object object) {
        if (object instanceof SubjectKeyIdentifier) {
            return (SubjectKeyIdentifier)object;
        }
        if (object != null) {
            return new SubjectKeyIdentifier(ASN1OctetString.getInstance(object));
        }
        return null;
    }

    public static SubjectKeyIdentifier fromExtensions(Extensions extensions) {
        return SubjectKeyIdentifier.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.subjectKeyIdentifier));
    }

    public SubjectKeyIdentifier(byte[] byArray) {
        this.keyidentifier = Arrays.clone(byArray);
    }

    protected SubjectKeyIdentifier(ASN1OctetString aSN1OctetString) {
        this(aSN1OctetString.getOctets());
    }

    public byte[] getKeyIdentifier() {
        return Arrays.clone(this.keyidentifier);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DEROctetString(this.getKeyIdentifier());
    }
}

