/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.bouncycastle.crypto.generators;

import com.dremio.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.CryptoServicePurpose;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import java.security.SecureRandom;

public class Ed448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("Ed448KeyGen", 224, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed448PrivateKeyParameters ed448PrivateKeyParameters = new Ed448PrivateKeyParameters(this.random);
        Ed448PublicKeyParameters ed448PublicKeyParameters = ed448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(ed448PublicKeyParameters, ed448PrivateKeyParameters);
    }
}

