/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.bouncycastle.crypto.generators;

import com.dremio.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.CryptoServicePurpose;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import java.security.SecureRandom;

public class X25519KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("X25519KeyGen", 128, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        X25519PrivateKeyParameters x25519PrivateKeyParameters = new X25519PrivateKeyParameters(this.random);
        X25519PublicKeyParameters x25519PublicKeyParameters = x25519PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(x25519PublicKeyParameters, x25519PrivateKeyParameters);
    }
}

