/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.bouncycastle.crypto.generators;

import com.dremio.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.CryptoServicePurpose;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.params.X448PublicKeyParameters;
import java.security.SecureRandom;

public class X448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("X448KeyGen", 224, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        X448PrivateKeyParameters x448PrivateKeyParameters = new X448PrivateKeyParameters(this.random);
        X448PublicKeyParameters x448PublicKeyParameters = x448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(x448PublicKeyParameters, x448PrivateKeyParameters);
    }
}

