/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.bouncycastle.crypto.prng;

import com.dremio.jdbc.shaded.org.bouncycastle.crypto.BlockCipher;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.params.KeyParameter;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.prng.BasicEntropySourceProvider;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.prng.EntropySourceProvider;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.prng.X931RNG;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.prng.X931SecureRandom;
import com.dremio.jdbc.shaded.org.bouncycastle.util.Arrays;
import com.dremio.jdbc.shaded.org.bouncycastle.util.Pack;
import java.security.SecureRandom;

public class X931SecureRandomBuilder {
    private SecureRandom random;
    private EntropySourceProvider entropySourceProvider;
    private byte[] dateTimeVector;

    public X931SecureRandomBuilder() {
        this(CryptoServicesRegistrar.getSecureRandom(), false);
    }

    public X931SecureRandomBuilder(SecureRandom secureRandom, boolean bl) {
        this.random = secureRandom;
        this.entropySourceProvider = new BasicEntropySourceProvider(this.random, bl);
    }

    public X931SecureRandomBuilder(EntropySourceProvider entropySourceProvider) {
        this.random = null;
        this.entropySourceProvider = entropySourceProvider;
    }

    public X931SecureRandomBuilder setDateTimeVector(byte[] byArray) {
        this.dateTimeVector = Arrays.clone(byArray);
        return this;
    }

    public X931SecureRandom build(BlockCipher blockCipher, KeyParameter keyParameter, boolean bl) {
        if (this.dateTimeVector == null) {
            this.dateTimeVector = new byte[blockCipher.getBlockSize()];
            Pack.longToBigEndian(System.currentTimeMillis(), this.dateTimeVector, 0);
        }
        blockCipher.init(true, keyParameter);
        return new X931SecureRandom(this.random, new X931RNG(blockCipher, this.dateTimeVector, this.entropySourceProvider.get(blockCipher.getBlockSize() * 8)), bl);
    }
}

