/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.bouncycastle.jcajce.provider.asymmetric;

import com.dremio.jdbc.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.dremio.jdbc.shaded.org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.CompositeSignaturesConstants;
import com.dremio.jdbc.shaded.org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.KeyFactorySpi;
import com.dremio.jdbc.shaded.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.dremio.jdbc.shaded.org.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import java.util.HashMap;
import java.util.Map;

public class CompositeSignatures {
    private static final String PREFIX = "com.dremio.jdbc.shaded.org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.";
    private static final Map<String, String> compositesAttributes = new HashMap<String, String>();

    static {
        compositesAttributes.put("SupportedKeyClasses", "com.dremio.jdbc.shaded.org.bouncycastle.jcajce.CompositePublicKey|org.bouncycastle.jcajce.CompositePrivateKey");
        compositesAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            for (ASN1ObjectIdentifier aSN1ObjectIdentifier : CompositeSignaturesConstants.supportedIdentifiers) {
                CompositeSignaturesConstants.CompositeName compositeName = CompositeSignaturesConstants.ASN1IdentifierAlgorithmNameMap.get(aSN1ObjectIdentifier);
                configurableProvider.addAlgorithm("KeyFactory." + compositeName.getId(), "com.dremio.jdbc.shaded.org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.KeyFactorySpi");
                configurableProvider.addAlgorithm("Alg.Alias.KeyFactory", aSN1ObjectIdentifier, compositeName.getId());
                configurableProvider.addAlgorithm("KeyPairGenerator." + compositeName.getId(), "com.dremio.jdbc.shaded.org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.KeyPairGeneratorSpi$" + (Object)((Object)compositeName));
                configurableProvider.addAlgorithm("Alg.Alias.KeyPairGenerator", aSN1ObjectIdentifier, compositeName.getId());
                configurableProvider.addAlgorithm("Signature." + compositeName.getId(), "com.dremio.jdbc.shaded.org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.SignatureSpi$" + (Object)((Object)compositeName));
                configurableProvider.addAlgorithm("Alg.Alias.Signature", aSN1ObjectIdentifier, compositeName.getId());
                configurableProvider.addKeyInfoConverter(aSN1ObjectIdentifier, new KeyFactorySpi());
            }
        }
    }
}

