/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.picnic;

import com.dremio.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.picnic.PicnicKeyGenerationParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.picnic.PicnicParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.picnic.PicnicPrivateKeyParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.picnic.PicnicPublicKeyParameters;
import java.security.SecureRandom;

public class PicnicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private PicnicParameters parameters;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        this.parameters = ((PicnicKeyGenerationParameters)keyGenerationParameters).getParameters();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        PicnicEngine picnicEngine = this.parameters.getEngine();
        byte[] byArray = new byte[picnicEngine.getSecretKeySize()];
        byte[] byArray2 = new byte[picnicEngine.getPublicKeySize()];
        picnicEngine.crypto_sign_keypair(byArray2, byArray, this.random);
        PicnicPublicKeyParameters picnicPublicKeyParameters = new PicnicPublicKeyParameters(this.parameters, byArray2);
        PicnicPrivateKeyParameters picnicPrivateKeyParameters = new PicnicPrivateKeyParameters(this.parameters, byArray);
        return new AsymmetricCipherKeyPair(picnicPublicKeyParameters, picnicPrivateKeyParameters);
    }
}

