/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.xwing;

import com.dremio.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyGenerationParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyPairGenerator;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.xwing.XWingPrivateKeyParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.xwing.XWingPublicKeyParameters;
import java.security.SecureRandom;

public class XWingKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    private void initialize(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        KyberKeyPairGenerator kyberKeyPairGenerator = new KyberKeyPairGenerator();
        kyberKeyPairGenerator.init(new KyberKeyGenerationParameters(this.random, KyberParameters.kyber768));
        X25519KeyPairGenerator x25519KeyPairGenerator = new X25519KeyPairGenerator();
        x25519KeyPairGenerator.init(new X25519KeyGenerationParameters(this.random));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = kyberKeyPairGenerator.generateKeyPair();
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = x25519KeyPairGenerator.generateKeyPair();
        return new AsymmetricCipherKeyPair(new XWingPublicKeyParameters(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair2.getPublic()), new XWingPrivateKeyParameters(asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPrivate()));
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

