/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.bouncycastle.pqc.jcajce.provider.cmce;

import com.dremio.jdbc.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.cmce.CMCEPublicKeyParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.jcajce.interfaces.CMCEKey;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.jcajce.spec.CMCEParameterSpec;
import com.dremio.jdbc.shaded.org.bouncycastle.util.Arrays;
import com.dremio.jdbc.shaded.org.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;

public class BCCMCEPublicKey
implements PublicKey,
CMCEKey {
    private static final long serialVersionUID = 1L;
    private transient CMCEPublicKeyParameters params;

    public BCCMCEPublicKey(CMCEPublicKeyParameters cMCEPublicKeyParameters) {
        this.params = cMCEPublicKeyParameters;
    }

    public BCCMCEPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (CMCEPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCCMCEPublicKey) {
            BCCMCEPublicKey bCCMCEPublicKey = (BCCMCEPublicKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCCMCEPublicKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public CMCEParameterSpec getParameterSpec() {
        return CMCEParameterSpec.fromName(this.params.getParameters().getName());
    }

    CMCEPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

