/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.bouncycastle.pqc.jcajce.provider.cmce;

import com.dremio.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.dremio.jdbc.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.cmce.CMCEKeyGenerationParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.cmce.CMCEKeyPairGenerator;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.cmce.CMCEParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.cmce.CMCEPrivateKeyParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.crypto.cmce.CMCEPublicKeyParameters;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.jcajce.provider.cmce.BCCMCEPrivateKey;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.jcajce.provider.cmce.BCCMCEPublicKey;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import com.dremio.jdbc.shaded.org.bouncycastle.pqc.jcajce.spec.CMCEParameterSpec;
import com.dremio.jdbc.shaded.org.bouncycastle.util.Strings;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class CMCEKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    CMCEKeyGenerationParameters param;
    CMCEKeyPairGenerator engine = new CMCEKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public CMCEKeyPairGeneratorSpi() {
        super("CMCE");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        String string = CMCEKeyPairGeneratorSpi.getNameFromParams(algorithmParameterSpec);
        if (string == null) {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + algorithmParameterSpec);
        }
        this.param = new CMCEKeyGenerationParameters(secureRandom, (CMCEParameters)parameters.get(string));
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof CMCEParameterSpec) {
            CMCEParameterSpec cMCEParameterSpec = (CMCEParameterSpec)algorithmParameterSpec;
            return cMCEParameterSpec.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(algorithmParameterSpec));
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new CMCEKeyGenerationParameters(this.random, CMCEParameters.mceliece8192128fr3);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        CMCEPublicKeyParameters cMCEPublicKeyParameters = (CMCEPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        CMCEPrivateKeyParameters cMCEPrivateKeyParameters = (CMCEPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCCMCEPublicKey(cMCEPublicKeyParameters), new BCCMCEPrivateKey(cMCEPrivateKeyParameters));
    }

    static {
        parameters.put(CMCEParameterSpec.mceliece348864.getName(), CMCEParameters.mceliece348864r3);
        parameters.put(CMCEParameterSpec.mceliece348864f.getName(), CMCEParameters.mceliece348864fr3);
        parameters.put(CMCEParameterSpec.mceliece460896.getName(), CMCEParameters.mceliece460896r3);
        parameters.put(CMCEParameterSpec.mceliece460896f.getName(), CMCEParameters.mceliece460896fr3);
        parameters.put(CMCEParameterSpec.mceliece6688128.getName(), CMCEParameters.mceliece6688128r3);
        parameters.put(CMCEParameterSpec.mceliece6688128f.getName(), CMCEParameters.mceliece6688128fr3);
        parameters.put(CMCEParameterSpec.mceliece6960119.getName(), CMCEParameters.mceliece6960119r3);
        parameters.put(CMCEParameterSpec.mceliece6960119f.getName(), CMCEParameters.mceliece6960119fr3);
        parameters.put(CMCEParameterSpec.mceliece8192128.getName(), CMCEParameters.mceliece8192128r3);
        parameters.put(CMCEParameterSpec.mceliece8192128f.getName(), CMCEParameters.mceliece8192128fr3);
    }
}

